import { world } from '@minecraft/server';
const overworld = world.getDimension('overworld');
world.beforeEvents.itemUseOn.subscribe(e => {
    const plushies = [
        "sf_nba:bear_plush",
        "sf_nba:hamster_plush",
        "sf_nba:lion_plush",
        "sf_nba:penguin_plush",
        "sf_nba:shark_plush",
    ];
    const blockLocation = e.block.location;
    const blockFace = e.blockFace;
    const spawnLocation = { x: blockLocation.x + 0.5, y: blockLocation.y + 0.5, z: blockLocation.z + 0.5 };
    switch (blockFace) {
        case 'Up':
            spawnLocation.y += 0.5;
            break;
        case 'Down':
            spawnLocation.y -= 0.5;
            break;
        case 'North':
            spawnLocation.z -= 0.5;
            break;
        case 'South':
            spawnLocation.z += 0.5;
            break;
        case 'West':
            spawnLocation.x -= 0.5;
            break;
        case 'East':
            spawnLocation.x += 0.5;
            break;
    }
    const plushieEntity = overworld.getEntitiesAtBlockLocation(spawnLocation);
    if (plushies.includes(e.itemStack.typeId)) {
        if (plushieEntity.length !== 0) {
            e.cancel = true;
        }
    }
});